/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.chromemobileconn;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.util.LaunchTargetComposite;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ChromeMobileConnMainTab
extends AbstractLaunchConfigurationTab {
    private Text deviceText;
    private LaunchTargetComposite launchTargetGroup;
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ChromeMobileConnMainTab.this.notifyPanelChanged();
        }
    };

    public ChromeMobileConnMainTab() {
        this.setMessage("Create a configuration to connect to a running Chrome for Mobile");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(1, 3).applyTo(composite);
        Group group = new Group(composite, 0);
        group.setText("Connection parameters");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(12, 6).applyTo((Composite)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Device:");
        this.deviceText = new Text((Composite)group, 2052);
        this.deviceText.addModifyListener(this.textModifyListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.deviceText);
        this.launchTargetGroup = new LaunchTargetComposite(composite, 0, false, true, true);
        this.launchTargetGroup.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ChromeMobileConnMainTab.this.notifyPanelChanged();
            }
        });
        Label instructionsLabel = new Label(composite, 64);
        instructionsLabel.setText("Make sure that \"USB debugging\" is enabled on your Android device. Then connect it to your PC via USB.");
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo((Control)instructionsLabel);
        this.setControl((Control)composite);
    }

    public String getErrorMessage() {
        return this.launchTargetGroup.getErrorMessage();
    }

    public Image getImage() {
        return SDBGDebugUIPlugin.getImage("chrome_conn.png");
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper(configuration);
        this.deviceText.setText(chromeLauncher.getDevice());
        this.launchTargetGroup.setUrlTextValue(chromeLauncher.getUrl());
        this.launchTargetGroup.setLaunchTabWithUrl(chromeLauncher.isLaunchTabWithUrl());
        this.launchTargetGroup.setProjectTextValue(chromeLauncher.getProjectName());
        this.launchTargetGroup.setHtmlButtonSelection(false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setDevice(this.deviceText.getText());
        chromeLauncher.setShouldLaunchFile(false);
        chromeLauncher.setUrl(this.launchTargetGroup.getUrlString());
        chromeLauncher.setLaunchTabWithUrl(this.launchTargetGroup.isLaunchTabWithUrl());
        chromeLauncher.setProjectName(this.launchTargetGroup.getProject());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setApplicationName("");
    }

    protected void notifyPanelChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }
}

