/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.chromeconn;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.Fonts;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.util.LaunchTargetComposite;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ChromeConnMainTab
extends AbstractLaunchConfigurationTab {
    private Text hostText;
    private Text portText;
    private LaunchTargetComposite launchTargetGroup;
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ChromeConnMainTab.this.notifyPanelChanged();
        }
    };

    public ChromeConnMainTab() {
        this.setMessage("Create a configuration to connect to a running Chrome");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(1, 3).applyTo(composite);
        Group group = new Group(composite, 0);
        group.setText("Connection parameters");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(12, 6).applyTo((Composite)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Host:");
        this.hostText = new Text((Composite)group, 2052);
        this.hostText.addModifyListener(this.textModifyListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.hostText);
        label = new Label((Composite)group, 0);
        label.setText("Port:");
        this.portText = new Text((Composite)group, 2052);
        this.portText.addModifyListener(this.textModifyListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.portText);
        this.launchTargetGroup = new LaunchTargetComposite(composite, 0, false, true, false);
        this.launchTargetGroup.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ChromeConnMainTab.this.notifyPanelChanged();
            }
        });
        Label noteLabel = new Label(composite, 64);
        noteLabel.setText("Note for beginners: it is much easier to get started with the \"Launch Chrome\" Debug Configuration.\nConsider switching to it.");
        noteLabel.setFont(Fonts.getFontRegistry().getBold(""));
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo((Control)noteLabel);
        label = new Label(composite, 0);
        Label instructionsLabel = new Label(composite, 64);
        instructionsLabel.setText("To start Chrome with remote connections enabled, use the following flag(s):\n--remote-debugging-port=<port> [--user-data-dir=<remote-profile>]");
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo((Control)instructionsLabel);
        this.setControl((Control)composite);
    }

    public String getErrorMessage() {
        if (this.hostText.getText().length() == 0) {
            return "Host is not specified";
        }
        if (this.portText.getText().length() == 0) {
            return "Port is not specified";
        }
        try {
            Integer.parseInt(this.portText.getText());
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return this.launchTargetGroup.getErrorMessage();
    }

    public Image getImage() {
        return SDBGDebugUIPlugin.getImage("chrome_conn.png");
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper(configuration);
        this.hostText.setText(chromeLauncher.getConnectionHost());
        this.portText.setText(Integer.toString(chromeLauncher.getConnectionPort()));
        this.launchTargetGroup.setUrlTextValue(chromeLauncher.getUrl());
        this.launchTargetGroup.setProjectTextValue(chromeLauncher.getProjectName());
        this.launchTargetGroup.setHtmlButtonSelection(false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setConnectionHost(this.hostText.getText());
        chromeLauncher.setConnectionPort(Integer.parseInt(this.portText.getText()));
        chromeLauncher.setShouldLaunchFile(false);
        chromeLauncher.setUrl(this.launchTargetGroup.getUrlString());
        chromeLauncher.setProjectName(this.launchTargetGroup.getProject());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setApplicationName("");
    }

    protected void notifyPanelChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }
}

