/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.chromeapp;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.chrome.ChromeLaunchMessages;
import com.github.sdbg.debug.ui.internal.util.AppSelectionDialog;
import com.github.sdbg.debug.ui.internal.util.IResourceFilter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ChromeAppMainTab
extends AbstractLaunchConfigurationTab {
    private Button showOutputButton;
    private Text fileText;
    protected Text argumentText;
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ChromeAppMainTab.this.notifyPanelChanged();
        }
    };

    public ChromeAppMainTab() {
        this.setMessage("Create a configuration to launch a Chrome packaged app");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(1, 3).applyTo(composite);
        Group group = new Group(composite, 0);
        group.setText(ChromeLaunchMessages.ChromeMainTab_LaunchTarget);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Select a manifest.json file describing a Chrome packaged app");
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)label);
        this.fileText = new Text((Composite)group, 2052);
        this.fileText.addModifyListener(this.textModifyListener);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fileText);
        Button browseButton = new Button((Composite)group, 8);
        browseButton.setText(ChromeLaunchMessages.ChromeMainTab_SelectHtmlFile);
        PixelConverter converter = new PixelConverter((Control)browseButton);
        int widthHint = converter.convertHorizontalDLUsToPixels(61);
        GridDataFactory.swtDefaults().align(4, 1).hint(widthHint, -1).applyTo((Control)browseButton);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromeAppMainTab.this.handleBrowseButton();
            }
        });
        group = new Group(composite, 0);
        group.setText("Chrome settings");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        this.showOutputButton = new Button((Composite)group, 32);
        this.showOutputButton.setText("Show browser stdout and stderr output");
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.showOutputButton);
        this.showOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromeAppMainTab.this.notifyPanelChanged();
            }
        });
        Label argsLabel = new Label((Composite)group, 0);
        argsLabel.setText("Browser arguments:");
        this.argumentText = new Text((Composite)group, 2052);
        this.argumentText.addModifyListener(this.textModifyListener);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.argumentText);
        this.setControl((Control)composite);
    }

    public String getErrorMessage() {
        if (this.fileText.getText().length() == 0) {
            return "manifest.json file not specified";
        }
        return null;
    }

    public Image getImage() {
        return SDBGDebugUIPlugin.getImage("chrome_app.png");
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper(configuration);
        this.fileText.setText(chromeLauncher.getApplicationName());
        if (this.showOutputButton != null) {
            this.showOutputButton.setSelection(chromeLauncher.getShowLaunchOutput());
        }
        this.argumentText.setText(chromeLauncher.getArguments());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setApplicationName(this.fileText.getText());
        if (this.showOutputButton != null) {
            chromeLauncher.setShowLaunchOutput(this.showOutputButton.getSelection());
        }
        chromeLauncher.setArguments(this.argumentText.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setApplicationName("");
    }

    protected void handleBrowseButton() {
        IFile file;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        AppSelectionDialog dialog = new AppSelectionDialog(this.getShell(), (IContainer)workspace.getRoot(), new ManifestResourceFilter());
        dialog.setTitle("Select a manifest.json file");
        dialog.setInitialPattern(".", 2);
        Path path = new Path(this.fileText.getText());
        if (workspace.validatePath(path.toString(), 1).isOK() && (file = workspace.getRoot().getFile((IPath)path)) != null && file.exists()) {
            dialog.setInitialSelections(new Object[]{path});
        }
        dialog.open();
        Object[] results = dialog.getResult();
        if (results != null && results.length > 0 && results[0] instanceof IFile) {
            IFile resource = (IFile)results[0];
            this.fileText.setText(resource.getFullPath().toPortableString());
        }
    }

    protected void notifyPanelChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public static class ManifestResourceFilter
    implements IResourceFilter {
        @Override
        public boolean matches(IResource resource) {
            return resource.getName().equals("manifest.json");
        }
    }
}

