/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.chromeapp;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.util.AbstractLaunchShortcut;
import com.github.sdbg.debug.ui.internal.util.ILaunchShortcutExt;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.utilities.Streams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.json.JSONException;
import org.json.JSONObject;

public class ChromeAppLaunchShortcut
extends AbstractLaunchShortcut
implements ILaunchShortcutExt {
    public static final String MANIFEST_FILE_NAME = "manifest.json";

    public static boolean containsManifestJsonFile(IContainer container) {
        return ChromeAppLaunchShortcut.findManifestJsonFile(container) != null;
    }

    public static boolean isManifestFile(IResource resource) {
        return resource instanceof IFile && resource.getName().equals(MANIFEST_FILE_NAME);
    }

    private static IFile findManifestJsonFile(IContainer container) {
        if (container.exists((IPath)new Path(MANIFEST_FILE_NAME))) {
            return container.getFile((IPath)new Path(MANIFEST_FILE_NAME));
        }
        if (container.getParent() != null) {
            return ChromeAppLaunchShortcut.findManifestJsonFile(container.getParent());
        }
        return null;
    }

    public ChromeAppLaunchShortcut() {
        super("Chrome App");
    }

    @Override
    public boolean canLaunch(IResource resource) {
        if (resource instanceof IContainer) {
            return ChromeAppLaunchShortcut.containsManifestJsonFile((IContainer)resource);
        }
        return ChromeAppLaunchShortcut.containsManifestJsonFile(resource.getParent());
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.chromeAppLaunchConfig");
        return type;
    }

    @Override
    protected IResource getLaunchableResource(Object originalResource) {
        if (!(originalResource instanceof IResource)) {
            return null;
        }
        IResource resource = (IResource)originalResource;
        if (resource instanceof IContainer) {
            return ChromeAppLaunchShortcut.findManifestJsonFile((IContainer)resource);
        }
        return ChromeAppLaunchShortcut.findManifestJsonFile(resource.getParent());
    }

    @Override
    protected void launch(IResource resource, String mode) {
        ILaunchConfiguration config;
        if (resource == null) {
            return;
        }
        try {
            config = this.findConfig(resource);
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
        if (config == null) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.chromeAppLaunchConfig");
            try {
                ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, manager.generateLaunchConfigurationName(this.getLaunchName(resource)));
                SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper((ILaunchConfiguration)launchConfig);
                launchWrapper.setApplicationName(resource.getFullPath().toString());
                launchWrapper.setProjectName(resource.getProject().getName());
                launchConfig.setMappedResources(new IResource[]{resource});
                config = launchConfig.doSave();
            }
            catch (CoreException e) {
                DartUtil.logError(e);
                return;
            }
        }
        LaunchUtils.clearConsoles();
        SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper(config);
        launchWrapper.markAsLaunched();
        LaunchUtils.launch(config, mode);
    }

    @Override
    protected boolean testSimilar(IResource resource, ILaunchConfiguration config) {
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(config);
        IResource configResource = wrapper.getApplicationResource();
        if (configResource == null || !ChromeAppLaunchShortcut.isManifestFile(configResource)) {
            return false;
        }
        IResource launchAbleResource = this.getLaunchableResource(resource);
        return configResource.equals((Object)launchAbleResource);
    }

    private String getLaunchName(IResource jsonResource) {
        String name = this.parseNameFromJson(jsonResource);
        return name == null ? jsonResource.getName() : name;
    }

    private String parseNameFromJson(IResource resource) {
        if (!(resource instanceof IFile)) {
            return null;
        }
        try {
            IFile file = (IFile)resource;
            String text = Streams.loadAndClose((Reader)new InputStreamReader(file.getContents(), "UTF-8"));
            JSONObject obj = new JSONObject(text);
            return obj.optString("name", null);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
        }
        catch (JSONException jSONException) {}
        return null;
    }
}

