/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.chrome;

import com.github.sdbg.debug.core.model.ISDBGDebugTarget;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DevToolsDisconnectManager {
    final ISDBGDebugTarget target;
    private Display display;
    private Shell shell;
    private ShellListener shellListener;
    private ILaunchListener launchListener;

    public DevToolsDisconnectManager(ISDBGDebugTarget target) {
        this.target = target;
        this.display = Display.getDefault();
        this.shellListener = new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                DevToolsDisconnectManager.this.handleShellActivated();
            }
        };
        this.launchListener = new ILaunchListener(){

            public void launchAdded(ILaunch launch) {
                DevToolsDisconnectManager.this.handleLaunchAdded(launch);
            }

            public void launchChanged(ILaunch launch) {
            }

            public void launchRemoved(ILaunch launch) {
                DevToolsDisconnectManager.this.handleLaunchRemoved(launch);
            }
        };
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DevToolsDisconnectManager.this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                DevToolsDisconnectManager.this.shell.addShellListener(DevToolsDisconnectManager.this.shellListener);
            }
        });
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.launchListener);
        this.printToConsole("<devtools opened - debugger connection paused>");
    }

    void dispose() {
        if (!this.display.isDisposed() && this.launchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.launchListener);
            this.launchListener = null;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DevToolsDisconnectManager.this.shell.removeShellListener(DevToolsDisconnectManager.this.shellListener);
                    DevToolsDisconnectManager.this.shellListener = null;
                }
            });
        }
    }

    private void handleLaunchAdded(ILaunch launch) {
        if (this.isSDBGLaunch(launch)) {
            this.dispose();
        }
    }

    private void handleLaunchRemoved(ILaunch launch) {
        if (launch == this.target.getLaunch()) {
            this.dispose();
        }
    }

    private void handleShellActivated() {
        if (this.display.isDisposed()) {
            return;
        }
        if (this.target.getProcess().isTerminated()) {
            this.dispose();
            return;
        }
        try {
            this.target.reconnect();
            this.printToConsole("<debugger connection resumed>");
            this.dispose();
        }
        catch (IOException iOException) {}
    }

    private boolean isSDBGLaunch(ILaunch launch) {
        try {
            return launch.getLaunchConfiguration().getType().getIdentifier().startsWith("com.github.sdbg.");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void printToConsole(String message) {
        this.target.writeToStdout(message);
    }
}

