/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.chrome;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.chrome.ChromeLaunchMessages;
import com.github.sdbg.debug.ui.internal.util.LaunchTargetComposite;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ChromeMainTab
extends AbstractLaunchConfigurationTab {
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ChromeMainTab.this.notifyPanelChanged();
        }
    };
    private Button showOutputButton;
    private Text argumentText;
    private LaunchTargetComposite launchTargetGroup;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(1, 3).applyTo(composite);
        this.launchTargetGroup = new LaunchTargetComposite(composite, 0);
        this.launchTargetGroup.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ChromeMainTab.this.notifyPanelChanged();
            }
        });
        Group group = new Group(composite, 0);
        group.setText("Chrome settings");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        ((GridLayout)group.getLayout()).marginBottom = 5;
        this.showOutputButton = new Button((Composite)group, 32);
        this.showOutputButton.setText("Show browser stdout and stderr output");
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.showOutputButton);
        this.showOutputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChromeMainTab.this.notifyPanelChanged();
            }
        });
        Label argsLabel = new Label((Composite)group, 0);
        argsLabel.setText("Browser arguments:");
        this.argumentText = new Text((Composite)group, 2052);
        this.argumentText.addModifyListener(this.textModifyListener);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.argumentText);
        this.setControl((Control)composite);
    }

    public String getErrorMessage() {
        return this.launchTargetGroup.getErrorMessage();
    }

    public Image getImage() {
        return SDBGDebugUIPlugin.getImage("chrome.png");
    }

    public String getMessage() {
        return ChromeLaunchMessages.ChromeMainTab_Message;
    }

    public String getName() {
        return ChromeLaunchMessages.ChromeMainTab_Name;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper(configuration);
        this.launchTargetGroup.setHtmlTextValue(chromeLauncher.appendQueryParams(chromeLauncher.getApplicationName()));
        this.launchTargetGroup.setUrlTextValue(chromeLauncher.getUrl());
        this.launchTargetGroup.setProjectTextValue(chromeLauncher.getProjectName());
        if (chromeLauncher.getShouldLaunchFile()) {
            this.launchTargetGroup.setHtmlButtonSelection(true);
        } else {
            this.launchTargetGroup.setHtmlButtonSelection(false);
        }
        this.showOutputButton.setSelection(chromeLauncher.getShowLaunchOutput());
        this.argumentText.setText(chromeLauncher.getArguments());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setShouldLaunchFile(this.launchTargetGroup.getHtmlButtonSelection());
        String fileUrl = this.launchTargetGroup.getHtmlFileName();
        if (fileUrl.indexOf(63) == -1) {
            chromeLauncher.setApplicationName(fileUrl);
            chromeLauncher.setUrlQueryParams("");
        } else {
            int index = fileUrl.indexOf(63);
            chromeLauncher.setApplicationName(fileUrl.substring(0, index));
            chromeLauncher.setUrlQueryParams(fileUrl.substring(index + 1));
        }
        chromeLauncher.setUrl(this.launchTargetGroup.getUrlString());
        chromeLauncher.setProjectName(this.launchTargetGroup.getProject());
        chromeLauncher.setShowLaunchOutput(this.showOutputButton.getSelection());
        chromeLauncher.setArguments(this.argumentText.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper chromeLauncher = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        chromeLauncher.setShouldLaunchFile(true);
        chromeLauncher.setApplicationName("");
    }

    private void notifyPanelChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }
}

