/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.chrome;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.util.AbstractLaunchShortcut;
import com.github.sdbg.debug.ui.internal.util.ILaunchShortcutExt;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class ChromeLaunchShortcut
extends AbstractLaunchShortcut
implements ILaunchShortcutExt {
    public ChromeLaunchShortcut() {
        super("Chrome");
    }

    @Override
    public boolean canLaunch(IResource resource) {
        if (resource instanceof IFile && "html".equalsIgnoreCase(resource.getFileExtension())) {
            return true;
        }
        return this.isBrowserApplication(resource);
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.chromeLaunchConfig");
        return type;
    }

    @Override
    public void launch(IResource resource, String mode) {
        this.launch(resource, mode, null);
    }

    public void launch(IResource resource, String mode, String url) {
        ILaunchConfiguration config;
        if (resource == null) {
            return;
        }
        try {
            config = this.findConfig(resource);
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
        if (config == null) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.chromeLaunchConfig");
            ILaunchConfigurationWorkingCopy launchConfig = null;
            try {
                launchConfig = type.newInstance(null, manager.generateLaunchConfigurationName(resource.getName()));
            }
            catch (CoreException ce) {
                DartUtil.logError(ce);
                return;
            }
            SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper((ILaunchConfiguration)launchConfig);
            launchWrapper.setApplicationName(resource.getFullPath().toString());
            launchWrapper.setProjectName(resource.getProject().getName());
            if (url != null) {
                launchWrapper.setUrl(url);
            }
            launchConfig.setMappedResources(new IResource[]{resource});
            try {
                config = launchConfig.doSave();
            }
            catch (CoreException e) {
                DartUtil.logError(e);
                return;
            }
        }
        SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper(config);
        launchWrapper.markAsLaunched();
        LaunchUtils.clearConsoles();
        LaunchUtils.launch(config, mode);
    }

    @Override
    protected boolean testSimilar(IResource resource, ILaunchConfiguration config) {
        return super.testSimilar(resource, config);
    }
}

