/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.browser;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import com.github.sdbg.debug.ui.internal.browser.Messages;
import com.github.sdbg.debug.ui.internal.util.LaunchTargetComposite;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class BrowserMainTab
extends AbstractLaunchConfigurationTab {
    private LaunchTargetComposite launchTargetGroup;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(1, 3).applyTo(composite);
        this.launchTargetGroup = new LaunchTargetComposite(composite, 0);
        this.launchTargetGroup.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                BrowserMainTab.this.notifyPanelChanged();
            }
        });
        this.setControl((Control)composite);
    }

    public void dispose() {
        Control control = this.getControl();
        if (control != null) {
            control.dispose();
            this.setControl(null);
        }
    }

    public String getErrorMessage() {
        if (this.performSdkCheck() != null) {
            return this.performSdkCheck();
        }
        return this.launchTargetGroup.getErrorMessage();
    }

    public Image getImage() {
        return SDBGDebugUIPlugin.getImage("obj16/globe_dark.png");
    }

    public String getMessage() {
        return Messages.BrowserMainTab_Description;
    }

    public String getName() {
        return Messages.BrowserMainTab_Name;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(config);
        this.launchTargetGroup.setHtmlTextValue(wrapper.appendQueryParams(wrapper.getApplicationName()));
        this.launchTargetGroup.setUrlTextValue(wrapper.getUrl());
        this.launchTargetGroup.setProjectTextValue(wrapper.getProjectName());
        if (wrapper.getShouldLaunchFile()) {
            this.launchTargetGroup.setHtmlButtonSelection(true);
        } else {
            this.launchTargetGroup.setHtmlButtonSelection(false);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper((ILaunchConfiguration)config);
        wrapper.setShouldLaunchFile(this.launchTargetGroup.getHtmlButtonSelection());
        String fileUrl = this.launchTargetGroup.getHtmlFileName();
        if (fileUrl.indexOf(63) == -1) {
            wrapper.setApplicationName(fileUrl);
            wrapper.setUrlQueryParams("");
        } else {
            int index = fileUrl.indexOf(63);
            wrapper.setApplicationName(fileUrl.substring(0, index));
            wrapper.setUrlQueryParams(fileUrl.substring(index + 1));
        }
        wrapper.setUrl(this.launchTargetGroup.getUrlString());
        wrapper.setProjectName(this.launchTargetGroup.getProject());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper((ILaunchConfiguration)configuration);
        wrapper.setShouldLaunchFile(true);
        wrapper.setApplicationName("");
    }

    private void notifyPanelChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    private String performSdkCheck() {
        return null;
    }
}

