/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.browser;

import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.util.AbstractLaunchShortcut;
import com.github.sdbg.debug.ui.internal.util.ILaunchShortcutExt;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

public class BrowserLaunchShortcut
extends AbstractLaunchShortcut
implements ILaunchShortcutExt {
    public BrowserLaunchShortcut() {
        super("Application");
    }

    @Override
    public boolean canLaunch(IResource resource) {
        if (resource instanceof IFile && "html".equalsIgnoreCase(resource.getFileExtension())) {
            return true;
        }
        return this.isBrowserApplication(resource);
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.browserLaunchConfig");
        return type;
    }

    @Override
    protected void launch(IResource resource, String mode) {
        ILaunchConfiguration config;
        mode = "run";
        if (resource == null) {
            return;
        }
        try {
            config = this.findConfig(resource);
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
        if (config != null) {
            LaunchUtils.launch(config, mode);
            return;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.browserLaunchConfig");
        ILaunchConfigurationWorkingCopy launchConfig = null;
        try {
            launchConfig = type.newInstance(null, manager.generateLaunchConfigurationName(resource.getName()));
        }
        catch (CoreException ce) {
            DartUtil.logError(ce);
            return;
        }
        SDBGLaunchConfigWrapper launchWrapper = new SDBGLaunchConfigWrapper((ILaunchConfiguration)launchConfig);
        launchWrapper.setProjectName(resource.getProject().getName());
        launchWrapper.setApplicationName(resource.getFullPath().toPortableString());
        launchConfig.setMappedResources(new IResource[]{resource});
        try {
            config = launchConfig.doSave();
        }
        catch (CoreException e) {
            DartUtil.logError(e);
            return;
        }
        LaunchUtils.launch(config, mode);
    }

    @Override
    protected boolean testSimilar(IResource resource, ILaunchConfiguration config) {
        return super.testSimilar(resource, config);
    }
}

