/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.browser;

import com.github.sdbg.core.DartCore;
import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.core.SDBGLaunchConfigWrapper;
import com.github.sdbg.debug.core.SDBGLaunchConfigurationDelegate;
import com.github.sdbg.debug.core.util.ResourceServer;
import com.github.sdbg.debug.core.util.ResourceServerManager;
import com.github.sdbg.debug.ui.internal.browser.Messages;
import com.github.sdbg.utilities.ProcessRunner;
import com.github.sdbg.utilities.instrumentation.InstrumentationBuilder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class BrowserLaunchConfigurationDelegate
extends SDBGLaunchConfigurationDelegate {
    public static void openBrowser(String url) throws CoreException {
        IWebBrowser browser = null;
        try {
            browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(128, "defaultBrowser", "Default Browser", "Browser");
            if (browser == null) {
                throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_DefaultBrowserNotFound));
            }
            final IWebBrowser defaultBrowser = browser;
            final URL urlToOpen = new URL(url);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        defaultBrowser.openURL(urlToOpen);
                    }
                    catch (PartInitException e) {
                        SDBGDebugCorePlugin.logError((String)Messages.BrowserLaunchConfigurationDelegate_DefaultBrowserNotFound, (Throwable)e);
                    }
                }
            });
        }
        catch (MalformedURLException malformedURLException) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_UrlError));
        }
    }

    public void doLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, InstrumentationBuilder instrumentation) throws CoreException {
        String url;
        mode = "run";
        SDBGLaunchConfigWrapper wrapper = new SDBGLaunchConfigWrapper(configuration);
        wrapper.markAsLaunched();
        if (wrapper.getShouldLaunchFile()) {
            IResource resource = wrapper.getApplicationResource();
            if (resource == null) {
                throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_HtmlFileNotFound));
            }
            try {
                ResourceServer server = ResourceServerManager.getServer();
                url = server.getUrlForResource(resource);
                url = wrapper.appendQueryParams(url);
            }
            catch (IOException ioe) {
                throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", "Could not launch browser - unable to start embedded server", (Throwable)ioe));
            }
        }
        url = wrapper.getUrl();
        try {
            String scheme = new URI(url).getScheme();
            if (scheme == null) {
                url = "http://" + url;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_UrlError));
        }
        if (SDBGDebugCorePlugin.getPlugin().getIsDefaultBrowser()) {
            BrowserLaunchConfigurationDelegate.openBrowser(url);
        } else {
            this.launchInExternalBrowser(url);
        }
        DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
    }

    private void launchInExternalBrowser(String url) throws CoreException {
        String browserName = SDBGDebugCorePlugin.getPlugin().getBrowserName();
        if (browserName.length() == 0) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.ui", "Specify browser to launch in Preferences > Run and Debug"));
        }
        ArrayList<String> cmd = new ArrayList<String>();
        if (DartCore.isMac()) {
            cmd.add("/usr/bin/open");
            cmd.add("-a");
        }
        cmd.add(browserName);
        cmd.add(url);
        if (SDBGDebugCorePlugin.getPlugin().getBrowserArgs().length() != 0) {
            if (DartCore.isMac()) {
                cmd.add("--args");
                cmd.add(SDBGDebugCorePlugin.getPlugin().getBrowserArgs());
            } else {
                cmd.addAll(Arrays.asList(SDBGDebugCorePlugin.getPlugin().getBrowserArgsAsArray()));
            }
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(cmd);
            ProcessRunner runner = new ProcessRunner(builder);
            runner.runAsync();
            runner.await((IProgressMonitor)new NullProgressMonitor(), 500);
            if (runner.getExitCode() != 0) {
                if (DartCore.isWindows() && browserName.toLowerCase().indexOf("firefox") != -1 && runner.getExitCode() == 1) {
                    return;
                }
                throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.ui", "Could not launch browser \"" + browserName + "\" : \n\n" + runner.getStdErr()));
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.github.sdbg.debug.core", Messages.BrowserLaunchConfigurationDelegate_BrowserNotFound, (Throwable)e));
        }
    }

    private IResource locateMappedFile(IResource resourceFile) {
        IResource mappedResource;
        String mappingPath = null;
        if (mappingPath != null && (mappedResource = ResourcesPlugin.getWorkspace().getRoot().findMember(Path.fromPortableString(mappingPath))) != null && mappedResource.exists()) {
            return mappedResource;
        }
        return null;
    }
}

