/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.breakpoints;

import com.github.sdbg.debug.core.breakpoints.SDBGBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class SDBGBreakpointAdapter
implements IToggleBreakpointsTarget {
    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.getEditor(part) != null;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        AbstractTextEditor editor = this.getEditor(part);
        if (editor != null) {
            IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
            String filePath = null;
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
                IEditorInput input = editor.getEditorInput();
                if (input instanceof FileStoreEditorInput) {
                    filePath = ((FileStoreEditorInput)input).getURI().getPath();
                }
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.github.sdbg.debug.core");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (resource.equals((Object)breakpoint.getMarker().getResource()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                    breakpoint.delete();
                    return;
                }
                ++i;
            }
            try {
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                IRegion lineInfo = document.getLineInformation(textSelection.getStartLine());
                String line = document.get(lineInfo.getOffset(), lineInfo.getLength());
                line = line.trim();
                if (line.length() == 0) {
                    return;
                }
                if (line.startsWith("//")) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {}
            SDBGBreakpoint breakpoint = new SDBGBreakpoint(resource, lineNumber, filePath);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)breakpoint);
        }
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    protected AbstractTextEditor getEditor(IWorkbenchPart part) {
        if (part instanceof AbstractTextEditor) {
            return (AbstractTextEditor)part;
        }
        return null;
    }
}

