/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.androidreverseforwards;

import com.github.sdbg.debug.core.SDBGReverseForwardsLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class AndroidReverseForwardsMainTab
extends AbstractLaunchConfigurationTab {
    private static final int MAX_FORWARDS = 5;
    private Text deviceText;
    private Text deviceCommandPortText;
    private Text[] hostTexts = new Text[5];
    private Text[] portTexts = new Text[5];
    private Text[] devicePortTexts = new Text[5];
    protected ModifyListener textModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AndroidReverseForwardsMainTab.this.notifyPanelChanged();
        }
    };

    public AndroidReverseForwardsMainTab() {
        this.setMessage("Create a configuration to run port forwards on Android devices");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().spacing(1, 3).applyTo(composite);
        Group group = new Group(composite, 0);
        group.setText("Connection parameters");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.fillDefaults().numColumns(5).margins(12, 6).applyTo((Composite)group);
        Label label = new Label((Composite)group, 0);
        label.setText("Device:");
        this.deviceText = new Text((Composite)group, 2052);
        this.deviceText.addModifyListener(this.textModifyListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.deviceText);
        label = new Label((Composite)group, 0);
        label = new Label((Composite)group, 0);
        label.setText("Command port:");
        this.deviceCommandPortText = new Text((Composite)group, 2052);
        this.deviceCommandPortText.addModifyListener(this.textModifyListener);
        GridDataFactory.swtDefaults().hint(40, -1).applyTo((Control)this.deviceCommandPortText);
        Group pfGroup = new Group(composite, 0);
        pfGroup.setText("Forwarding rules");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)pfGroup);
        GridLayoutFactory.fillDefaults().numColumns(8).margins(12, 6).applyTo((Composite)pfGroup);
        label = new Label((Composite)pfGroup, 0);
        Composite columnLabel = new Composite((Composite)pfGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(columnLabel);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)columnLabel);
        label = new Label(columnLabel, 0);
        label.setText("Android Device");
        label = new Label(columnLabel, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        label = new Label((Composite)pfGroup, 0);
        columnLabel = new Composite((Composite)pfGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(columnLabel);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)columnLabel);
        label = new Label(columnLabel, 0);
        label.setText("Website");
        label = new Label(columnLabel, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)label);
        int i = 0;
        while (i < 5) {
            label = new Label((Composite)pfGroup, 0);
            label.setText(String.valueOf(i + 1) + ": ");
            Text deviceHostText = new Text((Composite)pfGroup, 2052);
            deviceHostText.setEnabled(false);
            deviceHostText.setText("localhost");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)deviceHostText);
            label = new Label((Composite)pfGroup, 0);
            label.setText(":");
            this.devicePortTexts[i] = new Text((Composite)pfGroup, 2052);
            this.devicePortTexts[i].addModifyListener(this.textModifyListener);
            GridDataFactory.swtDefaults().hint(40, -1).applyTo((Control)this.devicePortTexts[i]);
            label = new Label((Composite)pfGroup, 0);
            label.setText("->");
            GridDataFactory.swtDefaults().hint(20, -1).applyTo((Control)label);
            this.hostTexts[i] = new Text((Composite)pfGroup, 2052);
            this.hostTexts[i].addModifyListener(this.textModifyListener);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.hostTexts[i]);
            label = new Label((Composite)pfGroup, 0);
            label.setText(":");
            this.portTexts[i] = new Text((Composite)pfGroup, 2052);
            this.portTexts[i].addModifyListener(this.textModifyListener);
            GridDataFactory.swtDefaults().hint(40, -1).applyTo((Control)this.portTexts[i]);
            ++i;
        }
        Label instructionsLabel = new Label(composite, 64);
        instructionsLabel.setText("Make sure that \"USB debugging\" is enabled on your Android device. Then connect it to your PC via USB.\n\nUse this feature to expose to the mobile browser development websites running on your PC or LAN (e.g. http://localhost:8080/<my-j2ee-app>).\n\nThis method may not work for public websites that inspect the HTTP Host header (e.g. http://gwtproject.org).");
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)instructionsLabel);
        this.setControl((Control)composite);
    }

    public String getErrorMessage() {
        if (this.deviceCommandPortText.getText().trim().length() == 0) {
            return "Enter device command port";
        }
        try {
            int commandPort = Integer.parseInt(this.deviceCommandPortText.getText().trim());
            if (commandPort < 0 || commandPort > 65535) {
                return "Command port out of range (0 - 65536)";
            }
        }
        catch (Exception e) {
            return "Invalid command port: " + e.getMessage();
        }
        String message = null;
        int i = 0;
        while (i < 5) {
            String host = this.hostTexts[i].getText().trim();
            String portStr = this.portTexts[i].getText().trim();
            String devicePortStr = this.devicePortTexts[i].getText().trim();
            if (host.length() > 0 || portStr.length() > 0 || devicePortStr.length() > 0) {
                if (host.length() == 0) {
                    message = "Enter host";
                } else if (portStr.length() == 0) {
                    message = "Enter port";
                } else if (devicePortStr.length() == 0) {
                    message = "Enter device port";
                } else {
                    try {
                        int port = Integer.parseInt(portStr);
                        if (port < 0 || port > 65535) {
                            message = "Port out of range (0 - 65536)";
                        }
                    }
                    catch (Exception e) {
                        message = "Invalid port: " + e.getMessage();
                    }
                    if (message == null) {
                        try {
                            int devicePort = Integer.parseInt(devicePortStr);
                            if (devicePort < 0 || devicePort > 65535) {
                                message = "Device port out of range (0 - 65536)";
                            }
                        }
                        catch (Exception e) {
                            message = "Invalid device port: " + e.getMessage();
                        }
                    }
                }
                if (message != null) {
                    message = "Rule " + (i + 1) + ": " + message;
                    break;
                }
            }
            ++i;
        }
        return message;
    }

    public Image getImage() {
        return SDBGDebugUIPlugin.getImage("chrome_conn.png");
    }

    public String getName() {
        return "Main";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        SDBGReverseForwardsLaunchConfigWrapper launchConfig = new SDBGReverseForwardsLaunchConfigWrapper(configuration);
        this.deviceText.setText(launchConfig.getDevice());
        this.deviceCommandPortText.setText(Integer.toString(launchConfig.getDeviceCommandPort()));
        List rules = launchConfig.getReverseForwards();
        int i = 0;
        while (i < 5) {
            if (i < rules.size()) {
                String rule = (String)rules.get(i);
                this.hostTexts[i].setText(SDBGReverseForwardsLaunchConfigWrapper.getReverseForwardHost((String)rule));
                this.portTexts[i].setText(Integer.toString(SDBGReverseForwardsLaunchConfigWrapper.getReverseForwardPort((String)rule)));
                this.devicePortTexts[i].setText(Integer.toString(SDBGReverseForwardsLaunchConfigWrapper.getReverseForwardDevicePort((String)rule)));
            } else {
                this.hostTexts[i].setText("");
                this.portTexts[i].setText("");
                this.devicePortTexts[i].setText("");
            }
            ++i;
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int commandPort;
        SDBGReverseForwardsLaunchConfigWrapper launchConfig = new SDBGReverseForwardsLaunchConfigWrapper((ILaunchConfiguration)configuration);
        launchConfig.setDevice(this.deviceText.getText().trim());
        try {
            commandPort = Integer.parseInt(this.deviceCommandPortText.getText().trim());
        }
        catch (Exception exception) {
            commandPort = -1;
        }
        launchConfig.setDeviceCommandPort(commandPort);
        ArrayList<String> rules = new ArrayList<String>();
        int i = 0;
        while (i < 5) {
            String host = this.hostTexts[i].getText().trim();
            String portStr = this.portTexts[i].getText().trim();
            String devicePortStr = this.devicePortTexts[i].getText().trim();
            if (host.length() > 0 || portStr.length() > 0 || devicePortStr.length() > 0) {
                int devicePort;
                int port;
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (Exception exception) {
                    port = -1;
                }
                try {
                    devicePort = Integer.parseInt(devicePortStr);
                }
                catch (Exception exception) {
                    devicePort = -1;
                }
                rules.add(SDBGReverseForwardsLaunchConfigWrapper.getReverseForward((String)host, (int)port, (int)devicePort));
            }
            ++i;
        }
        launchConfig.setReverseForwards(rules);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        SDBGReverseForwardsLaunchConfigWrapper launchConfig = new SDBGReverseForwardsLaunchConfigWrapper((ILaunchConfiguration)configuration);
        launchConfig.setDevice("");
        launchConfig.setDeviceCommandPort(6565);
        launchConfig.setReverseForwardsStr("");
    }

    protected void notifyPanelChanged() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }
}

