/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.androidreverseforwards;

import com.github.sdbg.debug.core.SDBGReverseForwardsLaunchConfigWrapper;
import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.util.AbstractLaunchShortcut;
import com.github.sdbg.debug.ui.internal.util.ILaunchShortcutExt;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import com.github.sdbg.utilities.Streams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidReverseForwardsLaunchShortcut
extends AbstractLaunchShortcut
implements ILaunchShortcutExt {
    public AndroidReverseForwardsLaunchShortcut() {
        super("Forward Ports to Android Device");
    }

    @Override
    public boolean canLaunch(IResource resource) {
        return false;
    }

    @Override
    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.androidReverseForwardsLaunchConfig");
        return type;
    }

    @Override
    protected IResource getLaunchableResource(Object originalResource) {
        return null;
    }

    @Override
    protected void launch(IResource resource, String mode) {
        ILaunchConfiguration config;
        if (resource == null) {
            return;
        }
        try {
            config = this.findConfig(resource);
        }
        catch (OperationCanceledException operationCanceledException) {
            return;
        }
        if (config == null) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("com.github.sdbg.debug.core.androidReverseForwardsLaunchConfig");
            try {
                ILaunchConfigurationWorkingCopy launchConfig = type.newInstance(null, manager.generateLaunchConfigurationName(this.getLaunchName(resource)));
                config = launchConfig.doSave();
            }
            catch (CoreException e) {
                DartUtil.logError(e);
                return;
            }
        }
        LaunchUtils.clearConsoles();
        SDBGReverseForwardsLaunchConfigWrapper launchWrapper = new SDBGReverseForwardsLaunchConfigWrapper(config);
        launchWrapper.markAsLaunched();
        LaunchUtils.launch(config, mode);
    }

    @Override
    protected boolean testSimilar(IResource resource, ILaunchConfiguration config) {
        return false;
    }

    private String getLaunchName(IResource jsonResource) {
        String name = this.parseNameFromJson(jsonResource);
        return name == null ? jsonResource.getName() : name;
    }

    private String parseNameFromJson(IResource resource) {
        if (!(resource instanceof IFile)) {
            return null;
        }
        try {
            IFile file = (IFile)resource;
            String text = Streams.loadAndClose((Reader)new InputStreamReader(file.getContents(), "UTF-8"));
            JSONObject obj = new JSONObject(text);
            return obj.optString("name", null);
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {
        }
        catch (JSONException jSONException) {}
        return null;
    }
}

