/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal.actions;

import com.github.sdbg.debug.core.model.ISDBGVariable;
import com.github.sdbg.debug.ui.internal.actions.ViewFilterAction;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;

public class GlobalVariablesFilterAction
extends ViewFilterAction {
    @Override
    public void runWithEvent(IAction action, Event event) {
        if (action.isChecked() && !MessageDialog.openConfirm((Shell)this.view.getViewSite().getShell(), (String)"Warning", (String)"Vizualizing global variables can significantly slow down the debugger.\nWould you like to still shown them?")) {
            return;
        }
        super.runWithEvent(action, event);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (!this.getValue() && element instanceof ISDBGVariable) {
            ISDBGVariable variable = (ISDBGVariable)element;
            try {
                return !variable.isScope() || !"global".equals(variable.getName());
            }
            catch (DebugException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

