/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal;

import com.github.sdbg.debug.core.IUserAgentManager;
import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.ui.internal.DartUtil;
import com.github.sdbg.debug.ui.internal.SDBGDebugUIPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SDBGDebugUserAgentManager
implements IUserAgentManager {
    private static boolean dialogOpen = false;
    private List<AgentData> agents = new ArrayList<AgentData>();

    static void install() {
        SDBGDebugCorePlugin.getPlugin().setUserAgentManager((IUserAgentManager)new SDBGDebugUserAgentManager());
    }

    private SDBGDebugUserAgentManager() {
        this.loadSettings();
    }

    public boolean allowUserAgent(InetAddress remoteAddress, String agentName) {
        if (agentName == null) {
            return false;
        }
        if (this.isKnownAgent(remoteAddress, agentName)) {
            return this.agentAllowed(remoteAddress, agentName);
        }
        dialogOpen = true;
        boolean allowConnection = this.askUserAllows(remoteAddress, agentName);
        this.addAgentData(remoteAddress, agentName, allowConnection);
        return allowConnection;
    }

    private void addAgentData(InetAddress remoteAddress, String agentName, boolean allowConnection) {
        AgentData data = new AgentData();
        data.address = remoteAddress.getHostAddress();
        data.agentName = agentName;
        data.allowed = allowConnection;
        this.agents.add(data);
        this.saveSettings();
    }

    private boolean agentAllowed(InetAddress remoteAddress, String agent) {
        if (agent == null) {
            return false;
        }
        String address = remoteAddress.getHostAddress();
        for (AgentData data : this.agents) {
            if (!address.equals(data.address) || !agent.equals(data.agentName)) continue;
            return data.allowed;
        }
        return false;
    }

    private boolean askUserAllows(final InetAddress remoteAddress, final String agent) {
        final boolean[] result = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                shell.forceActive();
                MessageDialog dialog = new MessageDialog(shell, "Allow Remote Device Connection", null, "Allow a remote device from " + remoteAddress.getHostAddress() + " to connect to and run your Dart applications?\n\n" + agent, 5, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                result[0] = dialog.open() == 0;
            }
        });
        return result[0];
    }

    private File getDataFile() {
        return SDBGDebugUIPlugin.getDefault().getStateLocation().append("agentdata.txt").toFile();
    }

    private boolean isKnownAgent(InetAddress remoteAddress, String agent) {
        String remoteAddressString = remoteAddress.getHostAddress();
        for (AgentData data : this.agents) {
            if (!remoteAddressString.equals(data.address) || !agent.equals(data.agentName)) continue;
            return true;
        }
        if (agent.equals("com.google.dart.editor.mobile.connection.service")) {
            for (AgentData data : this.agents) {
                if (!remoteAddressString.equals(data.address)) continue;
                this.addAgentData(remoteAddress, agent, true);
                return true;
            }
        }
        return false;
    }

    private void loadSettings() {
        File file = this.getDataFile();
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                while (line != null) {
                    AgentData agent = new AgentData();
                    agent.address = line;
                    agent.agentName = reader.readLine();
                    agent.allowed = Boolean.valueOf(reader.readLine());
                    this.agents.add(agent);
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (IOException ioe) {
                DartUtil.logError(ioe);
            }
        }
    }

    private void saveSettings() {
        File file = this.getDataFile();
        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));
            for (AgentData data : this.agents) {
                out.println(data.address);
                out.println(data.agentName);
                out.println(data.allowed);
            }
            out.close();
        }
        catch (IOException ioe) {
            DartUtil.logError(ioe);
        }
    }

    private static class AgentData {
        String address;
        String agentName;
        boolean allowed;

        private AgentData() {
        }
    }
}

