/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal;

import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.ui.internal.SDBGDebugUserAgentManager;
import com.github.sdbg.debug.ui.internal.objectinspector.InspectorActionFilter;
import com.github.sdbg.debug.ui.internal.presentation.SDBGElementAdapterFactory;
import com.github.sdbg.debug.ui.internal.util.PreferencesAdapter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;

public class SDBGDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.github.sdbg.debug.ui";
    private static Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>();
    private Map<String, Image> imageMap;
    private IPreferenceStore combinedPreferenceStore;
    private static SDBGDebugUIPlugin plugin;

    public static SDBGDebugUIPlugin getDefault() {
        return plugin;
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        Image image = imageCache.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            imageCache.put(imageDescriptor, image);
        }
        return image;
    }

    public static Image getImage(String imagePath) {
        return SDBGDebugUIPlugin.getDefault().getPluginImage(imagePath);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return SDBGDebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + path));
    }

    public static void logError(String message) {
        SDBGDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void logError(Throwable e) {
        SDBGDebugUIPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, e.toString(), e));
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.combinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.combinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(SDBGDebugCorePlugin.getPlugin().getPluginPreferences()), generalTextStore});
        }
        return this.combinedPreferenceStore;
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        this.imageMap = new HashMap<String, Image>();
        super.start(context);
        SDBGElementAdapterFactory.init();
        InspectorActionFilter.registerAdapters();
        SDBGDebugUserAgentManager.install();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.disposeImageCache();
        plugin = null;
    }

    private void disposeImageCache() {
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        this.imageMap = null;
    }

    private Image getPluginImage(String imagePath) {
        ImageDescriptor imageDescriptor;
        if (this.imageMap.get(imagePath) == null && (imageDescriptor = SDBGDebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + imagePath))) != null) {
            this.imageMap.put(imagePath, imageDescriptor.createImage());
        }
        return this.imageMap.get(imagePath);
    }
}

