/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal;

import com.github.sdbg.core.DartCore;
import com.github.sdbg.debug.core.DebugUIHelper;
import com.github.sdbg.debug.core.SDBGDebugCorePlugin;
import com.github.sdbg.debug.core.model.ISDBGDebugTarget;
import com.github.sdbg.debug.ui.internal.chrome.DevToolsDisconnectManager;
import com.github.sdbg.debug.ui.internal.util.LaunchUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DefaultDebugUIHelper
extends DebugUIHelper {
    public void activateApplication(File application, String name) {
        if (DartCore.isMac()) {
            this.activateApplicationMacOS(application);
        } else if (DartCore.isWindows()) {
            this.bringWindowToFrontWin32(".*" + name + "\\z");
        } else {
            DartCore.isLinux();
        }
    }

    public void handleDevtoolsDisconnect(ISDBGDebugTarget target) {
        new DevToolsDisconnectManager(target);
    }

    public void openBrowserTab(String url) {
        try {
            LaunchUtils.openBrowser(url);
        }
        catch (CoreException e) {
            this.showError("Open Browser", e.getMessage());
        }
    }

    public void showError(final String title, final String message) {
        final Display display = Display.getDefault();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public void showStatusLineMessage(final String message) {
        final Display display = Display.getDefault();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                Object part = null;
                if (part != null) {
                    IStatusLineManager manager = part.getViewSite().getActionBars().getStatusLineManager();
                    manager.setMessage(message);
                }
            }
        });
    }

    protected void activateApplicationMacOS(File app) {
        String appleScript = "tell application \"" + app.getName() + "\" to activate";
        ProcessBuilder builder = new ProcessBuilder("osascript", "-e", appleScript);
        try {
            builder.start();
        }
        catch (IOException e) {
            SDBGDebugCorePlugin.logError((Throwable)e);
        }
    }

    protected void bringWindowToFrontWin32(final String regex) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultDebugUIHelper.this.bringWindowToFrontWin32_impl(regex);
                }
                catch (Exception e) {
                    SDBGDebugCorePlugin.logError((Throwable)e);
                }
            }
        });
    }

    private void bringWindowToFrontWin32_impl(String regex) throws Exception {
        Pattern pattern = Pattern.compile(regex);
        Number window = this.OS_GetActiveWindow();
        while (window.longValue() != 0L) {
            String str;
            Matcher matcher;
            int textLength = this.OS_GetWindowTextLength(window);
            if (textLength > 0 && (matcher = pattern.matcher(str = this.OS_GetWindowText(window, textLength))).matches()) {
                this.OS_BringWindowToTop(window);
                return;
            }
            window = this.OS_GetWindow(window, 2);
        }
    }

    private Class<?> getOSClass() throws ClassNotFoundException {
        return Class.forName("org.eclipse.swt.internal.win32.OS");
    }

    private void OS_BringWindowToTop(Number window) throws Exception {
        if (window instanceof Integer) {
            Method method = this.getOSClass().getMethod("BringWindowToTop", Integer.TYPE);
            method.invoke(null, window.intValue());
        } else {
            Method method = this.getOSClass().getMethod("BringWindowToTop", Long.TYPE);
            method.invoke(null, window.longValue());
        }
    }

    private Number OS_GetActiveWindow() throws Exception {
        return (Number)this.getOSClass().getMethod("GetActiveWindow", new Class[0]).invoke(null, new Object[0]);
    }

    private Number OS_GetWindow(Number window, int direction) throws Exception {
        if (window instanceof Integer) {
            Method method = this.getOSClass().getMethod("GetWindow", Integer.TYPE, Integer.TYPE);
            return (Number)method.invoke(null, window.intValue(), direction);
        }
        Method method = this.getOSClass().getMethod("GetWindow", Long.TYPE, Integer.TYPE);
        return (Number)method.invoke(null, window.longValue(), direction);
    }

    private String OS_GetWindowText(Number window, int textLength) throws Exception {
        Method method;
        Class<?> tcharClass = Class.forName("org.eclipse.swt.internal.win32.TCHAR");
        Constructor<?> tcharCtor = tcharClass.getConstructor(Integer.TYPE, Integer.TYPE);
        Object tchar = tcharCtor.newInstance(0, textLength + 2);
        if (window instanceof Integer) {
            method = this.getOSClass().getMethod("GetWindowText", Integer.TYPE, tcharClass, Integer.TYPE);
            method.invoke(null, window.intValue(), tchar, textLength + 1);
        } else {
            method = this.getOSClass().getMethod("GetWindowText", Long.TYPE, tcharClass, Integer.TYPE);
            method.invoke(null, window.longValue(), tchar, textLength + 1);
        }
        Method tcharToString = tcharClass.getMethod("toString", Integer.TYPE, Integer.TYPE);
        return (String)tcharToString.invoke(tchar, 0, textLength);
    }

    private int OS_GetWindowTextLength(Number window) throws Exception {
        if (window instanceof Integer) {
            Method method = this.getOSClass().getMethod("GetWindowTextLength", Integer.TYPE);
            return (Integer)method.invoke(null, window.intValue());
        }
        Method method = this.getOSClass().getMethod("GetWindowTextLength", Long.TYPE);
        return (Integer)method.invoke(null, window.longValue());
    }
}

