/*
 * Decompiled with CFR 0.152.
 */
package com.github.sdbg.debug.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DebugErrorHandler {
    public static void errorDialog(Shell shell, String title, String message, IStatus status) {
        if (status != null && message.equals(status.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable exception) {
        IStatus status;
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        if (exception instanceof CoreException) {
            status = ((CoreException)exception).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, "com.github.sdbg.debug.ui", 120, "Error within Debug UI: ", exception);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    private DebugErrorHandler() {
    }
}

